/*
 * Decompiled with CFR 0.152.
 */
package jcommon.core.platform.win32;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.List;
import jcommon.core.platform.JNAUtils;
import jcommon.core.platform.win32.Win32Library;

public class Win32Platform {

    public static class Kernel32
    implements Win32Library {
        static CharacterEncodingFunctions char_encoding;
        public static final int INVALID_HANDLE_VALUE = -1;
        public static final int STD_INPUT_HANDLE = -10;
        public static final int STD_OUTPUT_HANDLE = -11;
        public static final int STD_ERROR_HANDLE = -12;
        public static final int FILE_SHARE_READ = 1;
        public static final int FILE_SHARE_WRITE = 2;
        public static final int GENERIC_READ = Integer.MIN_VALUE;
        public static final int GENERIC_WRITE = 0x40000000;
        public static final int CONSOLE_TEXTMODE_BUFFER = 1;

        public static native int CloseHandle(int var0);

        public static native int GetStdHandle(int var0);

        public static native int GetConsoleScreenBufferInfo(int var0, CONSOLE_SCREEN_BUFFER_INFO var1);

        public static native int CreateConsoleScreenBuffer(int var0, int var1, Pointer var2, int var3, Pointer var4);

        public static native int GetLastError();

        public static native int GetCurrentProcessId();

        public static int SetCurrentDirectory(String path) {
            return char_encoding.SetCurrentDirectory(path);
        }

        static {
            Native.register((String)"kernel32");
            char_encoding = USE_UNICODE ? new Unicode() : new ASCII();
        }

        public static class Unicode
        implements CharacterEncodingFunctions {
            public static native int SetCurrentDirectoryW(String var0);

            @Override
            public int SetCurrentDirectory(String path) {
                return Unicode.SetCurrentDirectoryW(path);
            }

            static {
                Native.register((String)"kernel32");
            }
        }

        public static class ASCII
        implements CharacterEncodingFunctions {
            public static native int SetCurrentDirectoryA(String var0);

            @Override
            public int SetCurrentDirectory(String path) {
                return ASCII.SetCurrentDirectoryA(path);
            }

            static {
                Native.register((String)"kernel32");
            }
        }

        public static interface CharacterEncodingFunctions {
            public int SetCurrentDirectory(String var1);
        }

        public static class CONSOLE_SCREEN_BUFFER_INFO
        extends Structure {
            public short wSizeX;
            public short wSizeY;
            public short wCursorPositionX;
            public short wCursorPositionY;
            public short wAttributes;
            public short wWindowLeft;
            public short wWindowTop;
            public short wWindowRight;
            public short wWindowBottom;
            public short wMaximumWindowSizeX;
            public short wMaximumWindowSizeY;

            public CONSOLE_SCREEN_BUFFER_INFO() {
            }

            public CONSOLE_SCREEN_BUFFER_INFO(Pointer memory) {
                super(memory);
                this.read();
            }

            protected List getFieldOrder() {
                return JNAUtils.fromSeq("wSizeX", "wSizeY", "wCursorPositionX", "wCursorPositionY", "wAttributes", "wWindowLeft", "wWindowTop", "wWindowRight", "wWindowBottom", "wMaximumWindowSizeX", "wMaximumWindowSizeY");
            }

            public static class ByReference
            extends CONSOLE_SCREEN_BUFFER_INFO
            implements Structure.ByReference {
            }
        }
    }

    public static class MSVCRT
    implements Win32Library {
        public static native String getenv(String var0);

        public static native int _putenv(String var0);

        static {
            Native.register((String)"msvcrt");
        }
    }
}

