/*
 * Decompiled with CFR 0.152.
 */
package jcommon.core.platform.win32;

import com.sun.jna.Pointer;
import java.io.Serializable;
import jcommon.core.Terminal;
import jcommon.core.platform.IPlatformImplementation;
import jcommon.core.platform.ITerminal;
import jcommon.core.platform.win32.Win32Platform;
import jcommon.core.platform.win32.Win32PlatformProvider;

public final class Terminal
extends Win32PlatformProvider
implements ITerminal,
Serializable {
    public static final ITerminal INSTANCE = new Terminal();
    private static final Object lock = new Object();

    @Override
    public IPlatformImplementation provideImplementation() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Terminal.Dimension queryTerminalDimensions() {
        long width = Terminal.DEFAULT_DIMENSIONS.Width;
        long height = Terminal.DEFAULT_DIMENSIONS.Height;
        Object object = lock;
        synchronized (object) {
            int handle = Win32Platform.Kernel32.GetStdHandle(-11);
            if (-1 != handle) {
                Win32Platform.Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Win32Platform.Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
                if (Win32Platform.Kernel32.GetConsoleScreenBufferInfo(handle, info) != 0) {
                    width = Math.max(0, info.wWindowRight - info.wWindowLeft + 1);
                    height = Math.max(0, info.wWindowBottom - info.wWindowTop + 1);
                } else {
                    int new_buffer_handle = Win32Platform.Kernel32.CreateConsoleScreenBuffer(-1073741824, 3, Pointer.NULL, 1, Pointer.NULL);
                    if (-1 != new_buffer_handle) {
                        try {
                            if (Win32Platform.Kernel32.GetConsoleScreenBufferInfo(new_buffer_handle, info) != 0) {
                                width = Math.max(0, info.wWindowRight - info.wWindowLeft + 1);
                                height = Math.max(0, info.wWindowBottom - info.wWindowTop + 1);
                            }
                        }
                        finally {
                            Win32Platform.Kernel32.CloseHandle(new_buffer_handle);
                        }
                    }
                }
                info = null;
            }
        }
        return new Terminal.Dimension(width, height);
    }
}

