/*
 * Decompiled with CFR 0.152.
 */
package jcommon.core.platform.win32;

import jcommon.core.platform.IEnv;
import jcommon.core.platform.IPlatformImplementation;
import jcommon.core.platform.win32.Win32Platform;
import jcommon.core.platform.win32.Win32PlatformProvider;

public final class Env
extends Win32PlatformProvider
implements IEnv {
    public static final IEnv INSTANCE = new Env();

    @Override
    public IPlatformImplementation provideImplementation() {
        return INSTANCE;
    }

    @Override
    public String querySystemPath() {
        return this.queryEnvironmentVariable("PATH");
    }

    @Override
    public String queryEnvironmentVariable(String name) {
        return Win32Platform.MSVCRT.getenv(name);
    }

    @Override
    public boolean saveEnvironmentVariable(String name, String value) {
        return Win32Platform.MSVCRT._putenv(name + "=" + value) == 0;
    }

    @Override
    public boolean unsetEnvironmentVariable(String name) {
        return Win32Platform.MSVCRT._putenv(name + "=") == 0;
    }
}

