/*
 * Decompiled with CFR 0.152.
 */
package jcommon.core.platform.unix;

import jcommon.core.platform.IEnv;
import jcommon.core.platform.IPlatformImplementation;
import jcommon.core.platform.unix.UnixPlatform;
import jcommon.core.platform.unix.UnixPlatformProvider;

public final class Env
extends UnixPlatformProvider
implements IEnv {
    public static final IEnv INSTANCE = new Env();

    @Override
    public IPlatformImplementation provideImplementation() {
        return INSTANCE;
    }

    @Override
    public String querySystemPath() {
        return this.queryEnvironmentVariable("PATH");
    }

    @Override
    public String queryEnvironmentVariable(String name) {
        return UnixPlatform.C.getenv(name);
    }

    @Override
    public boolean saveEnvironmentVariable(String name, String value) {
        return UnixPlatform.C.setenv(name, value, 1) == 0;
    }

    @Override
    public boolean unsetEnvironmentVariable(String name) {
        return UnixPlatform.C.unsetenv(name) == 0;
    }
}

