/*
 * Decompiled with CFR 0.152.
 */
package jcommon.core.platform;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import jcommon.core.Arch;
import jcommon.core.OS;
import jcommon.core.OSFamily;
import jcommon.core.platform.IPlatformImplementation;
import jcommon.core.platform.IPlatformProvider;

public class PlatformProviders {
    private static final Object lock = new Object();
    private static final ServiceLoader<IPlatformProvider> platform_provider_loader = ServiceLoader.load(IPlatformProvider.class);
    private static final Map<Class<? extends IPlatformImplementation>, IPlatformImplementation> providers = new HashMap<Class<? extends IPlatformImplementation>, IPlatformImplementation>(5, 1.0f);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        OSFamily family = OSFamily.getSystemOSFamily();
        OS os = OS.getSystemOS();
        Arch arch = Arch.getSystemArch();
        Object object = lock;
        synchronized (object) {
            platform_provider_loader.reload();
            providers.clear();
            for (IPlatformProvider provider : platform_provider_loader) {
                if (!provider.providerMatchesPlatform(family, os, arch)) continue;
                IPlatformImplementation impl = provider.provideImplementation();
                providers.put(impl.getClass(), impl);
            }
        }
    }

    public static <T extends IPlatformImplementation> T find(Class<T> interfaceClass) {
        return PlatformProviders.find(interfaceClass, null);
    }

    public static <T extends IPlatformImplementation> T find(Class<T> interfaceClass, T defaultImplementation) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException(interfaceClass.getName() + " must represent an interface");
        }
        IPlatformImplementation impl = null;
        for (Map.Entry<Class<? extends IPlatformImplementation>, IPlatformImplementation> e : providers.entrySet()) {
            if (!interfaceClass.isAssignableFrom(e.getKey())) continue;
            impl = e.getValue();
        }
        return (T)(impl != null ? impl : (IPlatformImplementation)defaultImplementation);
    }

    static {
        PlatformProviders.refresh();
    }
}

