/*
 * Decompiled with CFR 0.152.
 */
package jcommon.core;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import jcommon.core.Arch;
import jcommon.core.Env;
import jcommon.core.OS;
import jcommon.core.OSFamily;
import jcommon.core.Process;
import jcommon.core.StringUtil;

public class Sys {
    public static OS getOS() {
        return OS.getSystemOS();
    }

    public static OSFamily getOSFamily() {
        return OS.getSystemOSFamily();
    }

    public static Arch getArch() {
        return Arch.getSystemArch();
    }

    public static int getPID() {
        return Process.queryPID();
    }

    public static int getLastError() {
        return Process.queryLastError();
    }

    public static String querySystemPath() {
        return Env.querySystemPath();
    }

    public static String queryEnvironmentVariable(String name) {
        return Env.queryEnvironmentVariable(name);
    }

    protected static boolean loadResourcesAndWaitHelper(Future f) {
        if (f == null) {
            return false;
        }
        try {
            Object o = f.get();
            return true;
        }
        catch (CancellationException t) {
            return false;
        }
        catch (ExecutionException t) {
            return false;
        }
        catch (InterruptedException t) {
            return false;
        }
    }

    public static boolean isOS(OS OS2) {
        return OS2.getSystemOS() == OS2;
    }

    public static boolean isOSFamily(OSFamily OSFamily2) {
        return OS.getSystemOSFamily() == OSFamily2;
    }

    public static boolean isArch(Arch Arch2) {
        return Arch2.getSystemArch() == Arch2;
    }

    public static boolean isResourceAvailable(String ResourceName) {
        String res = (ResourceName.startsWith("/") && ResourceName.length() > 1 ? ResourceName.substring(1) : ResourceName).trim();
        if (StringUtil.isNullOrEmpty(res)) {
            return false;
        }
        return Thread.currentThread().getContextClassLoader().getResource(res) != null;
    }

    public static boolean saveEnvironmentVariable(String name, String value) {
        return Env.saveEnvironmentVariable(name, value);
    }

    public static boolean unsetEnvironmentVariable(String name) {
        return Env.unsetEnvironmentVariable(name);
    }

    public static String createPlatformName() {
        return Sys.createPlatformName(Sys.getOSFamily());
    }

    public static String createPlatformName(OS OS2) {
        return OS2.getPlatformPartName() + "." + Sys.getArch().getPlatformPartName();
    }

    public static String createPlatformName(OSFamily OSFamily2) {
        return OSFamily2.getPlatformPartName() + "." + Sys.getArch().getPlatformPartName();
    }

    public static String createPackageResourcePrefix(String PackagePrefix, String PackageSuffix) {
        String prefix = PackagePrefix.trim();
        String suffix = PackageSuffix.trim();
        return '/' + (!StringUtil.isNullOrEmpty(prefix) ? prefix.replace('.', '/') + '/' : "") + (!StringUtil.isNullOrEmpty(suffix) ? suffix.replace('.', '/') + '/' : "");
    }

    public static String createPackageResourcePrefix(String PackagePrefix) {
        return Sys.createPackageResourcePrefix(PackagePrefix, "");
    }

    public static String createPlatformPackageName(String PackagePrefix, String PlatformName, String PackageSuffix) {
        String prefix = PackagePrefix.trim();
        String suffix = PackageSuffix.trim();
        String ret = PlatformName;
        if (!StringUtil.isNullOrEmpty(prefix)) {
            ret = prefix.endsWith(".") ? prefix + ret : prefix + "." + ret;
        }
        if (!StringUtil.isNullOrEmpty(suffix)) {
            ret = suffix.startsWith(".") ? ret + suffix : ret + "." + suffix;
        }
        return ret;
    }

    public static String createPlatformPackageName(String PackagePrefix, String PackageSuffix) {
        return Sys.createPlatformPackageName(PackagePrefix, Sys.createPlatformName(), PackageSuffix);
    }

    public static String createPlatformPackageName(String PackagePrefix) {
        return Sys.createPlatformPackageName(PackagePrefix, Sys.createPlatformName(), "");
    }

    public static String createPlatformPackageName(String PackagePrefix, OS OS2, String PackageSuffix) {
        return Sys.createPlatformPackageName(PackagePrefix, Sys.createPlatformName(OS2), PackageSuffix);
    }

    public static String createPlatformPackageName(String PackagePrefix, OS OS2) {
        return Sys.createPlatformPackageName(PackagePrefix, Sys.createPlatformName(OS2), "");
    }

    public static String createPlatformPackageName(String PackagePrefix, OSFamily OSFamily2, String PackageSuffix) {
        return Sys.createPlatformPackageName(PackagePrefix, Sys.createPlatformName(OSFamily2), PackageSuffix);
    }

    public static String createPlatformPackageName(String PackagePrefix, OSFamily OSFamily2) {
        return Sys.createPlatformPackageName(PackagePrefix, Sys.createPlatformName(OSFamily2), "");
    }

    public static String createPlatformPackageResourcePrefix(String PackagePrefix, String PackageSuffix) {
        return Sys.createPackageResourcePrefix(Sys.createPlatformPackageName(PackagePrefix, PackageSuffix));
    }

    public static String createPlatformPackageResourcePrefix(String PackagePrefix) {
        return Sys.createPackageResourcePrefix(Sys.createPlatformPackageName(PackagePrefix));
    }

    public static String createPlatformPackageResourcePrefix(String PackagePrefix, OS OS2, String PackageSuffix) {
        return Sys.createPackageResourcePrefix(Sys.createPlatformPackageName(PackagePrefix, OS2, PackageSuffix));
    }

    public static String createPlatformPackageResourcePrefix(String PackagePrefix, OS OS2) {
        return Sys.createPackageResourcePrefix(Sys.createPlatformPackageName(PackagePrefix, OS2));
    }

    public static String createPlatformPackageResourcePrefix(String PackagePrefix, OSFamily OSFamily2, String PackageSuffix) {
        return Sys.createPackageResourcePrefix(Sys.createPlatformPackageName(PackagePrefix, OSFamily2, PackageSuffix));
    }

    public static String createPlatformPackageResourcePrefix(String PackagePrefix, OSFamily OSFamily2) {
        return Sys.createPackageResourcePrefix(Sys.createPlatformPackageName(PackagePrefix, OSFamily2));
    }

    public static String createPlatformPackageResourceName(String PackagePrefix, String PackageSuffix, String ResourceName) {
        return Sys.createPlatformPackageResourcePrefix(PackagePrefix, PackageSuffix) + ResourceName;
    }

    public static String createPlatformPackageResourceName(String PackagePrefix, String ResourceName) {
        return Sys.createPlatformPackageResourcePrefix(PackagePrefix) + ResourceName;
    }

    public static String createPlatformPackageResourceName(String PackagePrefix, OS OS2, String PackageSuffix, String ResourceName) {
        return Sys.createPlatformPackageResourcePrefix(PackagePrefix, OS2, PackageSuffix) + ResourceName;
    }

    public static String createPlatformPackageResourceName(String PackagePrefix, OS OS2, String ResourceName) {
        return Sys.createPlatformPackageResourcePrefix(PackagePrefix, OS2) + ResourceName;
    }

    public static String createPlatformPackageResourceName(String PackagePrefix, OSFamily OSFamily2, String PackageSuffix, String ResourceName) {
        return Sys.createPlatformPackageResourcePrefix(PackagePrefix, OSFamily2, PackageSuffix) + ResourceName;
    }

    public static String createPlatformPackageResourceName(String PackagePrefix, OSFamily OSFamily2, String ResourceName) {
        return Sys.createPlatformPackageResourcePrefix(PackagePrefix, OSFamily2) + ResourceName;
    }
}

