/*
 * Decompiled with CFR 0.152.
 */
package jcommon.core;

import java.io.File;
import jcommon.core.Path;
import jcommon.core.StringUtil;
import jcommon.core.platform.IProcess;
import jcommon.core.platform.PlatformProviders;

public class Process {
    private static final Object cwdLock = new Object();
    private static final IProcess impl = PlatformProviders.find(IProcess.class, IProcess.DEFAULT);
    private static String cwd = Path.workingDirectory;

    public static int queryLastError() {
        return impl.queryLastError();
    }

    public static int queryPID() {
        return impl.queryPID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String queryWorkingDirectory() {
        Object object = cwdLock;
        synchronized (object) {
            return cwd;
        }
    }

    public static boolean changeWorkingDirectory(File path) {
        if (path == null || !path.exists()) {
            return false;
        }
        return Process.changeWorkingDirectory(path.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean changeWorkingDirectory(String path) {
        if (StringUtil.isNullOrEmpty(path)) {
            return false;
        }
        Object object = cwdLock;
        synchronized (object) {
            boolean bl;
            block8: {
                String oldcwd = cwd;
                boolean ret = false;
                try {
                    cwd = path;
                    bl = ret = impl.changeWorkingDirectory(path);
                    if (ret) break block8;
                    cwd = oldcwd;
                }
                catch (Throwable throwable) {
                    if (!ret) {
                        cwd = oldcwd;
                    }
                    throw throwable;
                }
            }
            return bl;
        }
    }
}

