/*
 * Decompiled with CFR 0.152.
 */
package jcommon.core;

import java.io.File;
import jcommon.core.FileUtil;
import jcommon.core.StringUtil;
import jcommon.core.platform.IPath;
import jcommon.core.platform.PlatformProviders;

public class Path {
    public static final String directorySeparator = System.getProperty("file.separator");
    public static final String pathSeparator = File.pathSeparator;
    public static final String tempDirectory = Path.clean(System.getProperty("java.io.tmpdir"));
    public static final String homeDirectory = Path.clean(System.getProperty("user.home"));
    public static final String workingDirectory = Path.clean(new File(".").getAbsolutePath());
    public static final String nativeResourcesDirectoryName = "native_java_resources";
    public static final String nativeResourcesDirectory;
    private static IPath impl;

    public static String nativeDirectorySeparator(String path) {
        if (path == null) {
            return "";
        }
        return path.replace("/", directorySeparator).replace("\\", directorySeparator);
    }

    public static String clean(String path) {
        if (StringUtil.isNullOrEmpty(path)) {
            return "";
        }
        if (path.endsWith(directorySeparator)) {
            return path;
        }
        if (path.endsWith("/") || path.endsWith("\\")) {
            return path.substring(0, path.length() - 1) + directorySeparator;
        }
        return path + directorySeparator;
    }

    public static File combine(File parent, String child) {
        return new File(parent, child);
    }

    public static File combine(String parent, String child) {
        return new File(parent, child);
    }

    public static boolean exists(String path) {
        return Path.exists(new File(path));
    }

    public static boolean exists(File path) {
        if (path == null) {
            return false;
        }
        return path.exists();
    }

    public static boolean delete(String path) {
        return Path.delete(new File(path));
    }

    public static boolean delete(File path) {
        if (path == null) {
            return false;
        }
        try {
            if (!path.exists()) {
                return true;
            }
            if (path.isFile()) {
                return path.delete();
            }
            return FileUtil.deleteDirectory(path);
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static boolean createSymbolicLink(File to, File from) {
        if (from == null || to == null) {
            return false;
        }
        return Path.createSymbolicLink(to.getAbsolutePath(), from.getAbsolutePath());
    }

    public static boolean createSymbolicLink(String to, String from) {
        if (StringUtil.isNullOrEmpty(from) || StringUtil.isNullOrEmpty(to)) {
            throw new IllegalArgumentException("from and to cannot be empty");
        }
        return impl.createSymbolicLink(to, from);
    }

    static {
        impl = PlatformProviders.find(IPath.class, IPath.DEFAULT);
        nativeResourcesDirectory = Path.combine(tempDirectory, nativeResourcesDirectoryName).getAbsolutePath();
    }
}

