/*
 * Decompiled with CFR 0.152.
 */
package jcommon.core;

import jcommon.core.OS;
import jcommon.core.StringUtil;

public enum OSFamily {
    Unknown(""),
    Windows("windows"),
    Mac("osx"),
    Unix("unix"),
    Solaris("solaris"),
    VMS("vms");

    private String platformPartName;

    private OSFamily(String PlatformPartName) {
        this.platformPartName = PlatformPartName;
    }

    public static OSFamily getSystemOSFamily() {
        return OS.getSystemOSFamily();
    }

    public String getPlatformPartName() {
        return this.platformPartName;
    }

    public boolean isPOSIX() {
        return OSFamily.isPOSIX(this);
    }

    public static boolean isPOSIX(OS OS2) {
        return OSFamily.isPOSIX(OS2.getFamily());
    }

    public static boolean isPOSIX(OSFamily OSFamily2) {
        switch (OSFamily2) {
            case Unix: 
            case Mac: 
            case Solaris: {
                return true;
            }
        }
        return false;
    }

    public static OSFamily fromName(String Name) {
        if (StringUtil.isNullOrEmpty(Name)) {
            return Unknown;
        }
        for (OSFamily family : OSFamily.values()) {
            if (!family.platformPartName.equalsIgnoreCase(Name)) continue;
            return family;
        }
        String lower = Name.toLowerCase();
        if (lower.contains("win")) {
            return Windows;
        }
        if (lower.contains("mac")) {
            return Mac;
        }
        if (lower.contains("nix") || lower.contains("nux")) {
            return Unix;
        }
        if (lower.contains("vms")) {
            return VMS;
        }
        if (lower.contains("solaris")) {
            return Solaris;
        }
        return Unknown;
    }
}

