/*
 * Decompiled with CFR 0.152.
 */
package jcommon.core;

import jcommon.core.OSFamily;
import jcommon.core.StringUtil;

public enum OS {
    Unknown(OSFamily.Unknown, "", new String[0]),
    Windows95(OSFamily.Windows, "windows_95", "Windows 95"),
    Windows98(OSFamily.Windows, "windows_98", "Windows 98"),
    WindowsMe(OSFamily.Windows, "windows_me", "Windows Me"),
    WindowsNT(OSFamily.Windows, "windows_nt", "Windows NT"),
    Windows2000(OSFamily.Windows, "windows_2000", "Windows 2000"),
    WindowsXP(OSFamily.Windows, "windows_xp", "Windows XP"),
    Windows2003(OSFamily.Windows, "windows_2003", "Windows 2003"),
    Windows2008(OSFamily.Windows, "windows_2008", "Windows 2008"),
    WindowsVista(OSFamily.Windows, "windows_vista", "Windows Vista"),
    Windows7(OSFamily.Windows, "windows_7", "Windows 7"),
    Windows8(OSFamily.Windows, "windows_8", "Windows 8"),
    Windows9(OSFamily.Windows, "windows_9", "Windows 9"),
    WindowsCE(OSFamily.Windows, "windows_ce", "Windows CE"),
    OS2(OSFamily.Windows, "os_2", "OS/2"),
    WindowsUnknown(OSFamily.Windows, OSFamily.Windows.getPlatformPartName(), new String[0]),
    MacOSX(OSFamily.Mac, "osx", "Mac OS", "Mac OS X"),
    MacUnknown(OSFamily.Mac, OSFamily.Mac.getPlatformPartName(), new String[0]),
    Linux(OSFamily.Unix, "linux", "Linux"),
    MPE_iX(OSFamily.Unix, "mpe_ix", "MPE/iX"),
    HP_UX(OSFamily.Unix, "hp_ux", "HP-UX"),
    AIX(OSFamily.Unix, "aix", "AIX"),
    FreeBSD(OSFamily.Unix, "freebsd", "FreeBSD"),
    Irix(OSFamily.Unix, "irix", "Irix"),
    OS_390(OSFamily.Unix, "os390", "OS/390"),
    DigitalUnix(OSFamily.Unix, "digital_unix", "Digital Unix"),
    Netware_4_11(OSFamily.Unix, "netware_4_11", "NetWare 4.11"),
    OSF1(OSFamily.Unix, "osf1", "OSF1"),
    SunOS(OSFamily.Unix, "sunos", "SunOS"),
    UnixUnknown(OSFamily.Unix, OSFamily.Unix.getPlatformPartName(), new String[0]),
    Solaris(OSFamily.Solaris, "solaris", "Solaris"),
    SolarisUnknown(OSFamily.Solaris, OSFamily.Solaris.getPlatformPartName(), new String[0]),
    VMS(OSFamily.VMS, "openvms", "OpenVMS"),
    VMSUnknown(OSFamily.VMS, OSFamily.VMS.getPlatformPartName(), new String[0]);

    public static final String NAME;
    private static OS systemOS;
    private OSFamily family;
    private String[] variants;
    private String platformPartName;

    private OS(OSFamily OSFamily2, String PlatformPartName, String ... Variations) {
        this.family = OSFamily2;
        this.variants = Variations;
        this.platformPartName = PlatformPartName;
    }

    public static String getSystemOSName() {
        return NAME;
    }

    public static OS getSystemOS() {
        return systemOS;
    }

    public static OSFamily getSystemOSFamily() {
        return systemOS.getFamily();
    }

    public OSFamily getFamily() {
        return this.family;
    }

    public String[] getVariants() {
        return this.variants;
    }

    public String getPlatformPartName() {
        return this.platformPartName;
    }

    public boolean isPOSIX() {
        return OS.isPOSIX(this);
    }

    public static boolean isPOSIX(OS OS2) {
        return OSFamily.isPOSIX(OS2);
    }

    public static OS fromName(String Name) {
        if (StringUtil.isNullOrEmpty(Name)) {
            return Unknown;
        }
        for (OS os : OS.values()) {
            for (String variant : os.variants) {
                if (!variant.equalsIgnoreCase(Name)) continue;
                return os;
            }
        }
        String lower = Name.toLowerCase();
        if (lower.contains("win")) {
            return WindowsUnknown;
        }
        if (lower.contains("mac")) {
            return MacUnknown;
        }
        if (lower.contains("nix") || lower.contains("nux")) {
            return UnixUnknown;
        }
        if (lower.contains("vms")) {
            return VMSUnknown;
        }
        if (lower.contains("solaris")) {
            return SolarisUnknown;
        }
        return Unknown;
    }

    static {
        NAME = System.getProperty("os.name");
        systemOS = OS.fromName(NAME);
    }
}

