/*
 * Decompiled with CFR 0.152.
 */
package jcommon.core;

import java.io.File;
import java.util.Stack;

public class FileUtil {
    public static final boolean deleteDirectory(File path) {
        if (!path.isDirectory()) {
            throw new IllegalArgumentException("path must be a directory");
        }
        if (path == null) {
            return false;
        }
        if (!path.exists()) {
            return true;
        }
        try {
            File curr;
            Stack<File> stack = new Stack<File>();
            Stack<File> dir_stack = new Stack<File>();
            stack.push(path);
            while (!stack.empty() && (curr = (File)stack.pop()) != null) {
                for (File potential : curr.listFiles()) {
                    if (potential.isDirectory()) {
                        stack.push(potential);
                        dir_stack.push(potential);
                        continue;
                    }
                    potential.delete();
                }
            }
            while (!dir_stack.empty() && (curr = (File)dir_stack.pop()) != null) {
                curr.delete();
            }
            path.delete();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

