/*
 * Decompiled with CFR 0.152.
 */
package jcommon.core;

import jcommon.core.ArchWordSize;
import jcommon.core.StringUtil;

public enum Arch {
    Unknown(ArchWordSize.Unknown, "", new String[0]),
    x86(ArchWordSize.Size32Bits, "x86", "x86", "i386", "i686"),
    x86_64(ArchWordSize.Size64Bits, "x86_64", "x86_64", "x64", "amd64"),
    IA64(ArchWordSize.Size64Bits, "ia64", "IA64N"),
    PPC(ArchWordSize.Size32Bits, "ppc", "ppc", "PowerPC", "Power"),
    PPC64(ArchWordSize.Size64Bits, "ppc64", "ppc64"),
    Arm(ArchWordSize.Size32Bits, "arm", "arm"),
    ArmV4I(ArchWordSize.Size32Bits, "armv4i", "armv4i"),
    Sparc(ArchWordSize.Size64Bits, "sparc", "sparc"),
    PA_RISC(ArchWordSize.Size64Bits, "pa_risc", "PA-RISC", "PA_RISC2.0"),
    POWER_RS(ArchWordSize.Unknown, "power_rs", "POWER_RS"),
    MIPS(ArchWordSize.Size64Bits, "mips", "mips"),
    Alpha(ArchWordSize.Size64Bits, "alpha", "alpha");

    public static final String NAME;
    private static Arch systemArch;
    private String[] variants;
    private ArchWordSize wordSize;
    private String platformPartName;

    private Arch(ArchWordSize WordSize, String PlatformPartName, String ... Variations) {
        this.variants = Variations;
        this.wordSize = WordSize;
        this.platformPartName = PlatformPartName;
    }

    public static String getSystemArchName() {
        return NAME;
    }

    public static Arch getSystemArch() {
        return systemArch;
    }

    public String[] getVariants() {
        return this.variants;
    }

    public ArchWordSize getWordSize() {
        return this.wordSize;
    }

    public String getPlatformPartName() {
        return this.platformPartName;
    }

    public boolean is8Bit() {
        return this.wordSize == ArchWordSize.Size8Bits;
    }

    public boolean is16Bit() {
        return this.wordSize == ArchWordSize.Size16Bits;
    }

    public boolean is32Bit() {
        return this.wordSize == ArchWordSize.Size32Bits;
    }

    public boolean is64Bit() {
        return this.wordSize == ArchWordSize.Size64Bits;
    }

    public boolean is128Bit() {
        return this.wordSize == ArchWordSize.Size128Bits;
    }

    public boolean is256Bit() {
        return this.wordSize == ArchWordSize.Size256Bits;
    }

    public static Arch fromName(String Name) {
        if (StringUtil.isNullOrEmpty(Name)) {
            return Unknown;
        }
        for (Arch a : Arch.values()) {
            for (String variant : a.variants) {
                if (!variant.equalsIgnoreCase(Name)) continue;
                return a;
            }
        }
        return Unknown;
    }

    static {
        NAME = System.getProperty("os.arch");
        systemArch = Arch.fromName(NAME);
    }
}

